function [nF d] = nELBO2(s2,N,D,mu,s2min,h)
    
    % Negative evidence lower bound, second-order approximation.
    % Note that we exclude constant terms.
    %
    % USAGE: [nF d] = nELBO2(s2,N,D,mu,s2min,h)
    %
    % INPUTS:
    %   s2 - [N x 1] log variance parameters
    %   nlogpdf - function handle for negative log joint PDF
    %   N - number of components
    %   D - number of latent variables
    %   mu - component means
    %   s2min - minimum bandwidth
    %   h - [1 x N] Hessian trace for each component
    %
    % OUTPUTS:
    %   nF - negative approximate ELBO
    %   d - gradient
    %
    % Sam Gershman, Feb 2012

    % entropy lower bound
    if nargout > 1
        [nF , ~, ds2] = lower_bound_MoG([mu s2],N,D,s2min);
    else
        nF = lower_bound_MoG([mu s2],N,D,s2min);
    end

    s2 = exp(s2) + s2min;
    
    % calculate negative log joint and its derivatives
    for n = 1:N
        if nargout > 1  % get derivatives
            ds2(n) = ds2(n) + 0.5*(s2(n)-s2min)*h(n)/N;
        end
        nF = nF + 0.5*s2(n)*h(n)/N;
    end
    
    if nargout > 1; d = ds2'; end
