function [H dmu ds2] = lower_bound_MoG(theta,N,D,s2min,n)
    
    % Lower bound on the entropy of a mixture of Gaussians.
    
    mu = theta(:,1:D);
    s2 = exp(theta(:,end))' + s2min;
    beta = ones(N,1)./N;
    
    S = sq_dist(mu');
    s = bsxfun(@plus,s2,s2');
    P = exp(-0.5.*S./s)./((2*pi*s).^(D/2));
    a = beta'*P;
    H = log(a)*beta;
    
    %---------- derivatives -----------------%
    dmu = zeros(1,D);
    if nargout > 1 && nargout < 3
        dm = bsxfun(@plus,mu(n,:),-mu);
        for d = 1:D
            dS = zeros(N);
            dS(n,:) = dm(:,d);
            dS(:,n) = dm(:,d);
            dP = -P.*dS./s;
            dmu(d) = ((beta'*dP)./a)*beta;
        end
    end
    
    if nargout > 2
        ds2 = s2;
        for i = 1:N
            ds = zeros(N);
            ds(i,:) = 1; ds(:,i) = 1; ds(i,i) = 2;
            dP = P.*ds.*0.5.*(S./(s.^2) - D./s);
            ds2(i) = (s2(i)-s2min).*((beta'*dP)./a)*beta;
        end
    end