function F = ELBO(theta,nlogpdf,h,s2min)
    
    % Calculate evidence lower bound (2nd-order approximation, L2).
    
    [N K] = size(theta); D = K - 1;
    nF = lower_bound_MoG(theta,N,D,s2min);
    s2 = exp(theta(:,end)) + s2min;
    F = -nF;
    for n = 1:N
        nf = nlogpdf(theta(n,1:end-1));
        F = F - nf/N - 0.5*s2(n)*h(n)/N;
    end