function results = nmc_sim(sim)
    
    %Run latent cause model simulation.
    %
    %USAGE: results = nmc_sim(sim)
    %
    %INPUTS:
    %   sim - simulation number
    %
    %OUTPUTS:
    %   results - see imm.m
    
    N = 20;
    M = 100;
    alpha = 1;
    
    switch sim
        
        case 1  %conditioning with imperfect predictors (Wilson et al., 1992)
            N1 = 10; N2 = 40; N3 = 10;
            X = [repmat([1 1],N1,1); repmat([1 1],N2,1); repmat([1 0],N3,1)];         %consistent
            r = [repmat([1; 0],N1/2,1); repmat([1; 0],N2/2,1); ones(N3,1)];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([1 1],N1,1); repmat([1 1; 0 1],N2/2,1); repmat([1 0],N3,1)];  %shift
            r = [repmat([1; 0],N1/2,1); repmat([1; 0],N2/2,1); ones(N3,1)];
            results(2) = imm([r X],alpha,M);
            
        case 2  %PREE
            %partial reinforcment
            X = ones(N*2,1);
            r1 = repmat([1;0],N/2,1);
            r = [r1; zeros(N,1)];
            results(1) = imm([r X],alpha,M);
            
            %continuous reinforcement
            r = [ones(N,1); zeros(N,1)];
            results(2) = imm([r X],alpha,M);
            
        case 3  %external inhibition
            X = [[ones(N,1) zeros(N,1)]; ones(N,2)];
            r = [ones(N,1); zeros(N,1)];
            results(1) = imm([r X],alpha,M);
            
            X = [ones(N*2,1) zeros(N*2,1)];
            results(2) = imm([r X],alpha,M);
            
        case 7
            
        case 8 %positive & negative patterning
            %run it twice, since it seems sensitive to ordering
            N = 100;
            X = repmat([1 1; 1 0; 0 1],N,1);
            r = repmat([1; 0; 0],N,1);
            results(1) = imm([r X],alpha,M);
            X = repmat([1 1; 0 1; 1 0],N,1);
            r = repmat([1; 0; 0],N,1);
            results(2) = imm([r X],alpha,M);
            
            X = repmat([1 1; 1 0; 0 1],N,1);
            r = repmat([0; 1; 1],N,1);
            results(3) = imm([r X],alpha,M);
            X = repmat([1 1; 0 1; 1 0],N,1);
            r = repmat([0; 1; 1],N,1);
            results(4) = imm([r X],alpha,M);
            
        case 9 %biconditional discrimination
            %N = 50;
            N = 20;
            X = repmat([1 0 1 0; 1 0 0 1; 0 1 1 0; 0 1 0 1],N,1);
            r = repmat([1; 0; 0; 1],N,1);
            results(1) = imm([r X],alpha,M);
            
        case 10 %simultaneous feature positive discrimination and conditioned inhibition xxxxxxxxxx
            N = 10;
            X = [repmat([1 1 0 0; 0 1 0 0],N,1); repmat([0 0 1 1; 0 0 0 1],N,1)];
            r = [repmat([1; 0],N,1); repmat([1; 1],N,1)];
            results = imm([r X],alpha,M);
            
        case 11 %reinstatement xxxxxxxxxxxxxxxxxx
            N = 10;
            X = repmat([1 1 0],N*3,1);
            r = [ones(N,1); zeros(N,1); 1; zeros(N-1,1)];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([1 1 0],N*2,1); repmat([1 0 1],N,1)];
            r = [ones(N,1); zeros(N*2,1)];
            results(2) = imm([r X],alpha,M);
            
        case 12 %external disinhibition xxxxxxxxxxxxxxxxxxxxx
            X = [repmat([1 0],N*2,1); [0 1]; repmat([1 0],N,1)];
            X = [X ones(size(X,1),1)];
            r = [ones(N,1); zeros(N*2+1,1)];
            results(1) = imm([r X],alpha,M);
            
        case 13 %recovery from overshadowing xxxxxxxxxxxxxxxxxx
            X = [repmat([1 1],N,1); 0 1];
            r = [ones(N,1); 0];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([1 1],N,1); repmat([1 0],N,1); 0 1];
            r = [ones(N,1); zeros(N+1,1)];
            results(2) = imm([r X],alpha,M);
            
        case 14 
            
        case 15 %sensory preconditioning
            N = 40;
            %X = [repmat([1 1 0 1],N,1); repmat([1 0 0],N,1); 0 1 0];
            X = [repmat([1 1],N/2,1); repmat([1 0],N,1); 0 1];
            %X = [repmat([1 1 1],N,1); repmat([1 0 1],N,1); 0 1 1];
            r = [zeros(N/2,1); ones(N,1); 0];
            results(1) = imm([r X],alpha,M);
            
%             X = [repmat([1 1 0],N,1); 0 1 0];
%             r = [zeros(N,1); 0];
%             results(2) = imm([r X],alpha,M);
            
            X = [repmat([1 0],N,1); 0 1];
            %X = [repmat([1 0 1],N,1); 0 1 1];
            r = [ones(N,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 16 %second-order conditioning ********
            N1 = 96;        %A+
            N2 = [4 48];    %AB-
            N3 = 8;         %C+
            N4 = 1;         %B-/BC-
            for i = 1:length(N2)
                X = [repmat([1 0 0],N1,1); repmat([1 1 0],N2(i),1); repmat([0 0 1],N3,1); repmat([0 1 0],N4,1); repmat([0 1 1],N4,1)];
                r = [ones(N1,1); zeros(N2(i),1); ones(N3,1); zeros(N4*2,1)];
                results(i) = imm([r X],alpha,M);
            end
            
        case 17 %recovery from latent inhibition ***********
            N = 10;
            X = [repmat([0 1 0 0],N,1); repmat([1 1 0 0],N,1); repmat([0 0 1 0],N,1); repmat([1 0 0 1],N,1)];
            r = [zeros(N,1); ones(N,1); zeros(N,1); zeros(N,1)];
            results(1) = imm([r X],alpha,M);    %C-EXT
            
            X = [repmat([0 1 0 0],N,1); repmat([1 1 0 0],N,1); repmat([0 1 0 0],N,1); repmat([1 0 0 1],N,1)];
            r = [zeros(N,1); ones(N,1); zeros(N,1); zeros(N,1)];
            results(2) = imm([r X],alpha,M);    %C-EXT
            
            X = [repmat([1 1 0 0],N,1); repmat([1 1 0 0],N,1); repmat([0 0 1 0],N,1); repmat([1 0 0 1],N,1)];
            r = [zeros(N,1); ones(N,1); zeros(N,1); zeros(N,1)];
            results(3) = imm([r X],alpha,M);    %LI-HC
            
            X = [repmat([1 1 0 0],N,1); repmat([1 1 0 0],N,1); repmat([0 1 0 0],N,1); repmat([1 0 0 1],N,1)];
            r = [zeros(N,1); ones(N,1); zeros(N,1); zeros(N,1)];
            results(4) = imm([r X],alpha,M);    %LI-EXT
            
        case 18 %rapid/slow reacquisition (Ricker & Bouton, 1996) xxxxxxxxxxxxx
            N1 = [5 10];
            N2 = [10 20];
            f = 2;
            
            r = [ones(N1(1),1); zeros(N2(1),1); ones(5,1)];
            X = ones(size(r));
            results(1) = imm([r X],alpha,M);
            
            r = [ones(N1(2),1); zeros(N2(2),1); ones(5,1)];
            X = ones(size(r));
            results(2) = imm([r X],alpha,M);
  
            r = ones(5,1);
            X = ones(size(r));
            results(3) = imm([r X],alpha,M);
            
        case 19 %counterconditioning xxxxxxxxxxxxxxxxxxxx
            N = 5;
            opts.sr2 = 10;
            r = [ones(N,1); -ones(N,1)];
            X = ones(size(r));
            results{1} = nmc(X,r,opts);
            
        case 20 %ISI effects xxxxxxxxxxx
            ISI = 1:5;
            N = 5;
            opts.L = 1000;
            for i = 1:length(ISI)
                X = repmat([1; zeros(ISI(i),1)],N,1);
                r = repmat([zeros(ISI(i),1); 1],N,1);
                results{i} = nmc(X,r,opts);
            end
            
        case 21 %contingency (Rescorla, 1969)
            N = 20;
            X = [repmat([1 0]',N,1); ones(N,1)];
            r = [repmat([0 1 0 0]',N/2,1); ones(N,1)];
            %X = [repmat([1; 0],N,1); ones(N,1)];
            %r = [repmat([0; 1],N,1); ones(N,1)];
            results(1) = imm([r X],alpha,M);    %strong negative contingency

            %r = [repmat([1; 0],N,1); ones(N,1)];
            r = [repmat([0 1 0 0 0 0 0 0]',N/4,1); ones(N,1)];
            results(2) = imm([r X],alpha,M);    %weak negative contingency
            
        case 22 %extinction of conditioned inhibition
            r = [repmat([1; 0; 1],N,1); zeros(N,1); zeros(2,1)];
            X = [repmat([1 0 1; 1 0 0; 0 1 0],N,1); repmat([0 0 1],N,1); 0 1 1; 0 1 0];
            results(1) = imm([r X],alpha,M);    %CS-alone
            
            r = [repmat([1; 0; 1],N,1); ones(N,1); zeros(2,1)];
            results(2) = imm([r X],alpha,M);    %CS+
            
            X = [repmat([1 0 1; 1 0 0; 0 1 0],N,1); repmat([0 0 0],N,1); 0 1 1; 0 1 0];
            r = [repmat([1; 0; 1],N,1); zeros(N,1); zeros(2,1)];
            results(3) = imm([r X],alpha,M);    %no CS
            
        case 24 %US preexposure xxxxxxxxxxxxxxx
            N1 = 5; N2 = 75;
            X = [zeros(N1,1); ones(N2,1)];
            %X = [X ones(N1+N2,1)];
            r = ones(N1+N2,1);
            results(1) = imm([r X],alpha,M); %preexposure
            
            X = ones(N2,1);
            r = ones(N2,1);
            results(2) = imm([r X],alpha,M); %no preexposure
            
        case 25 %context preexposure xxxxxxxxxxxxxxx
            N1 = 5; N2 = 50;
            X = [repmat([0 1],N1,1); repmat([1 1],N2,1)];
            r = [zeros(N1,1); ones(N2,1)];
            results(1) = imm([r X],alpha,M); %preexposure
            
            X = [repmat([0 0],N1,1); repmat([1 1],N2,1)];
            r = [zeros(N1,1); ones(N2,1)];
            results(2) = imm([r X],alpha,M); %no preexposure
            
        case 26 %perceptual learning xxxxxxxxxxxxxxxxxxx
            N = 10;
            x1 = [1 1 1 1 0 0 0];
            x2 = [0 0 0 1 1 1 1];
            X = [repmat([x1; x2],N,1); repmat([x1; x2],N,1)];
            r = [zeros(N*2,1); repmat([1; 0],N,1)];
            results(1) = imm([r X],alpha,M); %preexposure

            X = repmat([x1; x2],N,1);
            r = repmat([1; 0],N,1);
            results(2) = imm([r X],alpha,M); %no preexposure
            
        case 27 %Hall-Pearce effect xxxxxxxxxxxxxx
            %N = 5;
            %X = ones(N*2,1);
            X = ones(N*2,2);
            r = [zeros(N,1)+0.5; ones(N,1)];
            results(1) = imm([r X],alpha,M); %preexposure

            X = [ones(N,1) zeros(N,1); zeros(N,1) ones(N,1)];
            results(2) = imm([r X],alpha,M); %no preexposure
            
        case 28 %transfer along a continuum (Haberlandt, 1971)
            N = 10;
            x1 = [1 0 0];
            x2 = [0 0 1];
            x3 = [1 1 0];
            x4 = [0 1 1];
            X = [repmat([x1; x2],N,1); repmat([x3; x4],N,1)];
            r = repmat([1; 0],N*2,1);
            results(1) = imm([r X],alpha,M); %preexposure

            X = [repmat([x3; x4],N,1); repmat([x3; x4],N,1)*2];
            r = repmat([1; 0],N*2,1);
            results(2) = imm([r X],alpha,M); %no preexposure
            
        case 29 %blocking xxxxxxxxxxxxxxx
            N1 = 20;
            N2 = 20;
            X = [repmat([1 0],N1,1); repmat([1 1],N2,1); 0 1];
            r = [ones(N1+N2,1); 0];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([1 1],N2,1); 0 1];
            r = [ones(N2,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 30 %overexpectation xxxxxxxxxxxxxxxxxxx
            N = 10;
            X = [repmat([1 0; 0 1],N,1); repmat([1 1],N,1); 0 1];
            r = [ones(N*3,1); 0];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([1 0; 0 1],N,1); 0 1];
            r = [ones(N*2,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 31 %overshadowing
            X = [repmat([1 1],N,1); 0 1];
            r = [ones(N,1); 0];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([0 1],N,1); 0 1];
            r = [ones(N,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 32 %superconditioning xxxxxxxxxxxxxxxxxxxxxxxxx
            N1 = 20;
            N2 = 20;
            X = [repmat([1 0],N1,1); repmat([1 1],N2,1); 0 1];
            r = [zeros(N1,1); ones(N2,1); 0];
            results(1) = imm([r X],alpha,M);
            
            X = [repmat([0 1],N2,1); 0 1];
            r = [ones(N2,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 33 %relative validity (Wagner et al., 1968) xxxxxxxxxxxxxxxxxxx
            
            %correlated
            X = [repmat([1 1 0; 1 0 1],N,1); 1 0 0];
            r = [repmat([1; 0],N,1); 0];
            results(1) = imm([r X],alpha,M);
            
            %uncorrelated
            r = [repmat([1; 0; 0; 1],N/2,1); 0];
            results(2) = imm([r X],alpha,M);
            
        case 34 
            
        case 35 %reinforcement/nonreinforcement of excitor in conditioned inhibition xxxxxxxxxxx
            N1 = 20; N2 = 20;
            r = [repmat([1; 0; 1],N1,1); zeros(N2,1); zeros(2,1)];
            X = [repmat([1 0 1; 1 0 0; 0 1 0],N1,1); repmat([1 0 0],N2,1); 0 1 1; 0 1 0];
            results(1) = imm([r X],alpha,M);    %CS-
            
            r = [repmat([1; 0; 1],N1,1); ones(N2,1); zeros(2,1)];
            results(2) = imm([r X],alpha,M);    %CS+
            
            X = [repmat([1 0 1; 1 0 0; 0 1 0],N1,1); repmat([0 0 0],N2,1); 0 1 1; 0 1 0];
            r = [repmat([1; 0; 1],N1,1); zeros(N2,1); zeros(2,1)];
            results(3) = imm([r X],alpha,M);    %no CS
            
    end